// Shader that shows mob spawner locations by daxnitro.

#version 120 // This will always get moved to the top of the code in pre-processing.

attribute vec4 mc_Entity;

#ifdef _ENABLE_GL_TEXTURE_2D
centroid varying vec4 texCoord;
#endif

varying vec4 vertColor;

void main() {
	gl_Position = ftransform();

#ifdef _ENABLE_GL_TEXTURE_2D
	texCoord = gl_MultiTexCoord0;
#endif

	if (mc_Entity.x == 52.0) {
		// Mob Spawner
		gl_Position.z = 0.0;
		vertColor = vec4(1.0, 0.0, 0.0, 1.0);
	} else {
		vertColor = gl_Color;
	}
		
	gl_FogFragCoord = gl_Position.z;
}
